#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

/******************************************************************************
Function Name  : TIM0ISR
Engineer       : r59709	
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 0.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void TIM0ISR(void) 
{
  PORTA_PA0 ^= 1;         //Toggle Port A0 to show output compare occured.
  TFLG1 = TFLG1_C0F_MASK; //Clear channel 0 flag.
}
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : TIM1ISR
Engineer       : r59709
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 1.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void TIM1ISR(void) 
{
  PORTA_PA1 ^= 1;         //Toggle Port A1 to show output compare occured.
  TFLG1 = TFLG1_C1F_MASK; //Clear channel 1 flag.
}
#pragma CODE_SEG DEFAULT


/******************************************************************************
Function Name  : TIM3ISR
Engineer       : r59709
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 3.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void TIM3ISR(void) 
{
  PORTA_PA3 ^= 1;         //Toggle Port A3 to show input capture occured.
  TFLG1 = TFLG1_C3F_MASK; //Clear channel 3 flag.
}
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : Perform_Output_Compare
Engineer       : r59709
Date           : 06/26/2009
Notes          : Function to setup Timer module for output compare.
******************************************************************************/
void Perform_Output_Compare(void)
{
  PORTA_PA0 = 0;  //Set Port A0 to 0. Will be used to toggle Demo board LED.
  PORTA_PA1 = 0;  //Set Port A1 to 0. Will be used to toggle Demo board LED.
  DDRA_DDRA0 = 1; //Set Port A0 as output.
  DDRA_DDRA1 = 1; //Set Port A1 as output.
    
  TSCR1_TEN = 0;  //Disable Timer module before adjusting registers.
  TIOS_IOS0 = 1;  //Set Channel 0 as output compare.
  TCTL2_OM0 = 0;  //Set channel 0 to toggle when a Timer match occurs.
  TCTL2_OL0 = 1;  //Set channel 0 to toggle when a Timer match occurs.
  TC0 = 0x8000;   //Set a value for channel 0 timer compare.
  TIE_C0I = 1;    //Enable channel 0 interrupt, handled by function TIM0ISR.
  TIOS_IOS1 = 1;  //Set Channel 1 as output compare.
  TCTL2_OM1 = 0;  //Set channel 1 to toggle when a Timer match occurs.
  TCTL2_OL1 = 1;  //Set channel 1 to toggle when a Timer match occurs.
  TC1 = 0xFFFF;   //Set channel 1 timer compare.
  TIE_C1I = 1;    //Enable channel 1 interrupt, handled by function TIM1ISR.
  TSCR1_TSWAI = 1;//Disables the timer module while in wait mode.
  TSCR1_TSFRZ = 1;//Disables the timer counter while in freeze mode.
  TSCR2_PR = 0x6; //Set prescaler to divide by 64.
  TSCR1_TEN = 1;  //Timer Enable.
}

/******************************************************************************
Function Name  : Perform_Input_Capture
Engineer       : r59709
Date           : 06/26/2009
Notes          : Timer channel 3 is set as an any-edge input capture.
******************************************************************************/
void Allow_Input_Capture(void)
{
  PORTA_PA3 = 0; //Set Port A3 to 0.
  DDRA_DDRA3 = 1;//Set Port A3 as output.
  PPST_PPST3 = 1;//Set Port T3 pull device polarity as low
  PERT_PERT3 = 1;//Enable Port T3 pull device.

  TSCR1_TEN = 0;  //Disable timer module before adjusting registers.
  TIOS_IOS3 = 0;  //Set Channel 3 as input capture.
  TCTL4_EDG3A = 1;//Set channel 3 to capture any edge transition.
  TCTL4_EDG3B = 1;//Set channel 3 to capture any edge transition.
  TIE_C3I = 1;    //Enable channel 3 interrupt, handled by function TIM1ISR.
  TSCR1_TSWAI = 1;//Disables the timer module while in wait mode.
  TSCR1_TSFRZ = 1;//Disables the timer counter while in freeze mode.
  TSCR2_PR = 0x6; //Set prescaler to divide by 64.
  TSCR1_TEN = 1;  //Timer Enable.
}

/******************************************************************************
Function Name  : main
Engineer       : r59709
Date           : 06/26/2009
Notes          : Call functions to setup Timer module output compare
               : and input capture.
******************************************************************************/
void main(void)
{
	EnableInterrupts;

  Perform_Output_Compare();
  Allow_Input_Capture();

  for(;;);       //Wait here forever.
  /* PLEASE MAKE SURE THAT YOU NEVER EXIT main(void) */
}
